/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToRetrieveCatInfl
extends Transformation
implements Cloneable {
    private static final String INFO = "Retrieve Cat Infl";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Object object;
        String string;
        String string2;
        Object object2;
        Object object3;
        Vector vector = ToRetrieveCatInfl.GetCatInfl(lexItem.GetSourceTerm(), connection);
        long l = lexItem.GetSourceCategory().GetValue();
        long l2 = lexItem.GetSourceInflection().GetValue();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            object3 = (InflectionRecord)vector.elementAt(n);
            ToRetrieveCatInfl.AddRecordToCombined((InflectionRecord)object3, vector2, l, l2);
            ++n;
        }
        object3 = new Vector();
        int n2 = 0;
        while (n2 < vector2.size()) {
            Object object4;
            object2 = (InflectionRecord)vector2.elementAt(n2);
            string2 = ((InflectionRecord)object2).GetInflectedTerm();
            string = null;
            object = null;
            if (bl) {
                string = INFO;
            }
            if (bl2) {
                object4 = GlobalBehavior.GetFieldSeparator();
                object = "FACT" + (String)object4 + Category.ToName(((InflectionRecord)object2).GetCategory()) + (String)object4 + Inflection.ToName(((InflectionRecord)object2).GetInflection()) + (String)object4;
            }
            object4 = Transformation.UpdateLexItem(lexItem, string2, 25, ((InflectionRecord)object2).GetCategory(), ((InflectionRecord)object2).GetInflection(), string, object);
            ((Vector)object3).addElement(object4);
            ++n2;
        }
        if (((Vector)object3).size() == 0) {
            object2 = ramTrie.GetCatInflByRules(lexItem.GetSourceTerm(), l, l2);
            string2 = GlobalBehavior.GetFieldSeparator();
            string = "RULE" + string2 + ((CatInfl)object2).GetCategoryStr() + string2 + ((CatInfl)object2).GetInflectionStr() + string2;
            object = Transformation.UpdateLexItem(lexItem, lexItem.GetSourceTerm(), 25, ((CatInfl)object2).GetCategory(), ((CatInfl)object2).GetInflection(), INFO, string);
            ((Vector)object3).addElement(object);
        }
        return object3;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "bloom");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToRetrieveCatInfl.Mutate(lexItem, connection, ramTrie, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static void AddRecordToCombined(InflectionRecord inflectionRecord, Vector vector, long l, long l2) {
        long l3;
        long l4 = inflectionRecord.GetCategory();
        if (!InputFilter.IsLegal(l, l2, l4, l3 = inflectionRecord.GetInflection())) {
            return;
        }
        if (vector.size() == 0) {
            vector.addElement(inflectionRecord);
        } else {
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                InflectionRecord inflectionRecord2 = (InflectionRecord)vector.elementAt(n);
                if (inflectionRecord2.GetInflectedTerm().equalsIgnoreCase(inflectionRecord.GetInflectedTerm())) {
                    bl = true;
                    inflectionRecord2.SetCategory(Bit.Add(inflectionRecord2.GetCategory(), (int)l4));
                    inflectionRecord2.SetInflection(Bit.Add(inflectionRecord2.GetInflection(), l3));
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector.addElement(inflectionRecord);
            }
        }
    }

    private static Vector GetCatInfl(String string, Connection connection) throws SQLException {
        Vector vector = DbInflection.GetCatInfl(string, connection);
        return vector;
    }
}

