/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbEui;
import gov.nih.nlm.nls.lvg.Db.EuiRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToRetrieveEui
extends Transformation
implements Cloneable {
    private static final String INFO = "Retrieve EUI";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToRetrieveEui.GetEui(lexItem.GetSourceTerm(), connection);
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            EuiRecord euiRecord = (EuiRecord)vector.elementAt(n);
            String string = null;
            String string2 = null;
            if (bl) {
                string = INFO;
            }
            if (bl2) {
                string2 = Transformation.NO_MUTATE_INFO;
            }
            LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, euiRecord.GetEui(), 24, euiRecord.GetCategory(), euiRecord.GetInflection(), string, string2);
            vector2.addElement(lexItem2);
            ++n;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "building");
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToRetrieveEui.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector GetEui(String string, Connection connection) throws SQLException {
        Vector vector = DbEui.GetEuisByInflectedTerm(string, connection);
        return vector;
    }
}

