/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Vector;

public class ToSimpleInflections
extends Transformation
implements Cloneable {
    private static final String INFO = "Simple Inflections";

    public static Vector Mutate(LexItem lexItem, boolean bl, boolean bl2) {
        ToSimpleInflections.GetSimpleInflectionsFromSource(lexItem);
        String string = null;
        String string2 = null;
        if (bl) {
            string = INFO;
        }
        if (bl2) {
            string2 = lexItem.GetSourceInflection().GetName() + GlobalBehavior.GetFieldSeparator() + lexItem.GetSourceInflection().GetValue() + GlobalBehavior.GetFieldSeparator();
        }
        Vector<LexItem> vector = new Vector<LexItem>();
        LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, lexItem.GetSourceTerm(), 50, lexItem.GetTargetCategory().GetValue(), lexItem.GetTargetInflection().GetValue(), string, string2);
        vector.addElement(lexItem2);
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = Transformation.GetTestStr(stringArray, "AIDS");
        LexItem lexItem = new LexItem(string);
        Vector vector = ToSimpleInflections.Mutate(lexItem, true, true);
        Transformation.PrintResults(lexItem, vector);
    }

    public static void GetSimpleInflectionsOnTarget(LexItem lexItem) {
        lexItem.SetTargetInflection(ToSimpleInflections.GetSimpleInflections(lexItem.GetTargetInflection().GetValue()));
    }

    private static void GetSimpleInflectionsFromSource(LexItem lexItem) {
        lexItem.SetTargetCategory(lexItem.GetSourceCategory().GetValue());
        lexItem.SetTargetInflection(ToSimpleInflections.GetSimpleInflections(lexItem.GetSourceInflection().GetValue()));
    }

    private static long GetSimpleInflections(long l) {
        long l2 = l;
        int n = 8;
        while (n < 24) {
            if ((l & BitMaskBase.mask_[n]) == BitMaskBase.mask_[n]) {
                l2 = Bit.Minus(l2, BitMaskBase.mask_[n]);
                l2 = Bit.Add(l2, Inflection.MapSimpleInfl_[n]);
            }
            ++n;
        }
        return l2;
    }
}

