/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbSpellingVariants;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToSpellingVariants
extends Transformation
implements Cloneable {
    private static final String INFO = "Spelling Variants";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) {
        Vector vector = ToSpellingVariants.SpellingVariant(lexItem.GetSourceTerm(), connection);
        long l = lexItem.GetSourceCategory().GetValue();
        long l2 = lexItem.GetSourceInflection().GetValue();
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            long l3;
            InflectionRecord inflectionRecord = (InflectionRecord)vector.elementAt(n);
            String string = inflectionRecord.GetInflectedTerm();
            long l4 = inflectionRecord.GetCategory();
            if (InputFilter.IsLegal(l, l2, l4, l3 = inflectionRecord.GetInflection())) {
                String string2 = null;
                String string3 = null;
                if (bl) {
                    string2 = INFO;
                }
                if (bl2) {
                    string3 = inflectionRecord.GetEui() + GlobalBehavior.GetFieldSeparator();
                }
                LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 14, l4, l3, string2, string3);
                vector2.addElement(lexItem2);
            }
            ++n;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "left");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToSpellingVariants.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    protected static Vector SpellingVariant(String string, Connection connection) {
        Vector vector = new Vector();
        try {
            vector = DbSpellingVariants.GetSpellingVariants(string, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }
}

