/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.StrTokenObject;
import gov.nih.nlm.nls.lvg.Util.Strip;
import gov.nih.nlm.nls.lvg.Util.StripToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;

public class ToStripStopWords
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip Stop Words";

    public static Vector Mutate(LexItem lexItem, Vector vector, boolean bl, boolean bl2) {
        String string = ToStripStopWords.StripStopWords(lexItem.GetSourceTerm(), vector);
        Vector vector2 = ToStripStopWords.GetMultipleStopWords(vector);
        string = Strip.StripStrings(string, vector2, false);
        String string2 = null;
        String string3 = null;
        if (bl) {
            string2 = INFO;
        }
        if (bl2) {
            string3 = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> vector3 = new Vector<LexItem>();
        LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 2, -1L, -1L, string2, string3);
        vector3.addElement(lexItem2);
        return vector3;
    }

    public static Vector GetStopWordsFromFile(Configuration configuration) {
        String string = configuration.GetConfiguration("LVG_DIR") + configuration.GetConfiguration("LVG_STOP_WORD_FILE");
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
            System.out.println("** Error: problem of opening/reading stop words file: '" + string + "'.");
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "On the Top");
        Vector vector = ToStripStopWords.GetStopWordsFromFile(configuration);
        LexItem lexItem = new LexItem(string);
        Vector vector2 = ToStripStopWords.Mutate(lexItem, vector, true, true);
        Transformation.PrintResults(lexItem, vector2);
    }

    private static String StripStopWords(String string, Vector vector) {
        Object object;
        Vector vector2 = StripToken.Tokenize(string);
        Vector<StrTokenObject> vector3 = new Vector<StrTokenObject>(vector2);
        int n = 0;
        while (n < vector2.size()) {
            object = (StrTokenObject)vector2.elementAt(n);
            if (((StrTokenObject)object).GetTokenType() == 1 && ToStripStopWords.IsContain(vector, ((StrTokenObject)object).GetTokenStr())) {
                StrTokenObject strTokenObject = new StrTokenObject(" ", 3);
                vector3.setElementAt(strTokenObject, n);
            }
            ++n;
        }
        object = StripToken.CleanUpToken(vector3);
        return StripToken.ComposeString((Vector)object).trim();
    }

    private static Vector GetMultipleStopWords(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        if (vector == null) {
            return vector;
        }
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string.indexOf(" ") != -1) {
                vector2.addElement(string);
            }
            ++n;
        }
        return vector2;
    }

    private static boolean IsContain(Vector vector, String string) {
        if (vector == null) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            if (string.equalsIgnoreCase((String)vector.elementAt(n))) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }
}

