/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Gender;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import java.util.StringTokenizer;
import java.util.Vector;

public class BitMaskBase {
    protected static final int MAX_BIT = 63;
    private static final String SP = "+";
    private static final String ALL_STR = "all";
    public static long[] mask_ = new long[63];
    private long value_;
    private long allBitValue_ = -1L;
    private Vector[] bitStr_ = new Vector[63];

    public BitMaskBase() {
        this.value_ = 0L;
    }

    public BitMaskBase(long l) {
        this.value_ = l;
    }

    protected BitMaskBase(long l, Vector[] vectorArray) {
        this.value_ = 0L;
        this.allBitValue_ = l;
        this.bitStr_ = vectorArray;
    }

    protected BitMaskBase(long l, long l2, Vector[] vectorArray) {
        this.value_ = l;
        this.allBitValue_ = l2;
        this.bitStr_ = vectorArray;
    }

    public static long GetBitValue(int n) {
        return mask_[n];
    }

    public static int GetBitIndex(long l) {
        int n = -1;
        int n2 = 0;
        while (n2 < 63) {
            if (l == mask_[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static boolean Contains(long l, long l2) {
        boolean bl = (l & l2) == l2;
        return bl;
    }

    protected static Vector ToValues(long l, int n) {
        if (l <= 0L && l > mask_[n]) {
            return null;
        }
        Vector<Long> vector = new Vector<Long>();
        int n2 = 0;
        while (n2 < n) {
            if ((l & mask_[n2]) != 0L) {
                vector.addElement(new Long(mask_[n2]));
            }
            ++n2;
        }
        return vector;
    }

    public void SetValue(long l) {
        if (l > 0L) {
            this.value_ = l;
        }
    }

    public boolean GetBitFlag(int n) {
        boolean bl = (this.value_ & mask_[n]) != 0L;
        return bl;
    }

    public void SetBitFlag(int n, boolean bl) {
        this.value_ = bl ? (this.value_ |= mask_[n]) : (this.value_ &= mask_[n] ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long GetValue() {
        return this.value_;
    }

    public String GetName() {
        return BitMaskBase.ToName(this.value_, this.allBitValue_, this.bitStr_);
    }

    public boolean Contains(long l) {
        return (this.value_ & l) == l;
    }

    protected static long ToValue(String string, Vector[] vectorArray) {
        long l = 0L;
        Vector vector = BitMaskBase.GetStringList(string);
        BitMaskBase bitMaskBase = new BitMaskBase();
        int n = 0;
        while (n < vector.size()) {
            int n2 = 0;
            while (n2 < 63) {
                int n3 = 0;
                while (n3 < vectorArray[n2].size()) {
                    String string2 = (String)vector.elementAt(n);
                    if (string2.equals((String)vectorArray[n2].elementAt(n3))) {
                        bitMaskBase.SetBitFlag(n2, true);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        l = bitMaskBase.GetValue();
        return l;
    }

    protected static String ToName(long l, long l2, Vector[] vectorArray) {
        if (l == l2) {
            return ALL_STR;
        }
        String string = null;
        int n = 0;
        while (n < 63) {
            if (vectorArray[n].size() >= 1 && (l & mask_[n]) != 0L) {
                string = string == null ? (String)vectorArray[n].elementAt(0) + SP : string + (String)vectorArray[n].elementAt(0) + SP;
            }
            ++n;
        }
        string = string != null ? string.substring(0, string.length() - 1) : new String();
        return string;
    }

    protected static long Enumerate(String string, Vector[] vectorArray) {
        long l = 0L;
        int n = 0;
        while (n < 63) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                if (string.equals((String)vectorArray[n].elementAt(n2))) {
                    l = mask_[n];
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return l;
    }

    protected static String GetBitName(int n, int n2, Vector[] vectorArray) {
        String string = null;
        if (n >= 63) {
            return string;
        }
        if (n2 < vectorArray[n].size()) {
            string = (String)vectorArray[n].elementAt(n2);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("----- static methods -------");
        System.out.println(" -  Gender.ToName(7): " + Gender.ToName(7L));
        System.out.println(" -  Gender.ToName(15): " + Gender.ToName(15L));
        System.out.println(" -  " + Gender.ToName(6L) + " contains " + Gender.ToName(2L) + ": " + Gender.Contains(6L, 2L));
        System.out.println(" -  " + Gender.ToName(6L) + " contains " + Gender.ToName(4L) + ": " + Gender.Contains(6L, 4L));
        System.out.println(" -  " + Gender.ToName(6L) + " contains " + Gender.ToName(5L) + ": " + Gender.Contains(6L, 5L));
        System.out.println(" -  Category.ToName(1030): " + Category.ToName(1030L));
        Vector vector = Category.ToValues(1030L);
        int n = 0;
        while (n < vector.size()) {
            System.out.println(" - Category.ToValues(1030): " + (Long)vector.elementAt(n));
            ++n;
        }
        System.out.println(" -  Category.ToName(2047): " + Category.ToName(2047L));
        System.out.println(" -  Inflection.ToName(2584): " + Inflection.ToName(2584L));
        System.out.println(" -  Inflection.ToName(16777215): " + Inflection.ToName(0xFFFFFFL));
        int n2 = 0;
        while (n2 < 63) {
            System.out.println(n2 + ": " + mask_[n2]);
            ++n2;
        }
    }

    private static Vector GetStringList(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, SP);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    static {
        BitMaskBase.mask_[0] = 1L;
        int n = 1;
        while (n < 63) {
            BitMaskBase.mask_[n] = mask_[n - 1] * 2L;
            ++n;
        }
    }
}

