/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Gender;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import java.util.Vector;

public class LexItem {
    private String mutateInfo_ = null;
    private String detailInfo_ = null;
    private int flowNum_ = 1;
    private int flowComponentNum_ = 1;
    private String flowHistory_ = null;
    private long tag_ = 3L;
    private String orgTerm_ = null;
    private String srcTerm_ = null;
    private String tarTerm_ = null;
    private Category srcCategory_ = new Category(2047L);
    private Category tarCategory_ = new Category();
    private Inflection srcInflection_ = new Inflection(0xFFFFFFL);
    private Inflection tarInflection_ = new Inflection();
    private Gender srcGender_ = new Gender();
    private Gender tarGender_ = new Gender();

    public LexItem() {
    }

    public LexItem(String string) {
        this.orgTerm_ = string;
        this.srcTerm_ = string;
    }

    public LexItem(String string, long l) {
        this.orgTerm_ = string;
        this.srcTerm_ = string;
        this.srcCategory_ = new Category(l);
    }

    public LexItem(String string, long l, long l2) {
        this.orgTerm_ = string;
        this.srcTerm_ = string;
        this.srcCategory_ = new Category(l);
        this.srcInflection_ = new Inflection(l2);
    }

    public LexItem(LexItem lexItem, boolean bl) {
        this.orgTerm_ = lexItem.GetOriginalTerm();
        this.srcTerm_ = lexItem.GetSourceTerm();
        this.srcCategory_ = new Category(lexItem.GetSourceCategory().GetValue());
        this.srcInflection_ = new Inflection(lexItem.GetSourceInflection().GetValue());
        this.srcGender_ = new Gender(lexItem.GetSourceGender().GetValue());
        this.detailInfo_ = lexItem.GetDetailInformation();
        this.flowHistory_ = lexItem.GetFlowHistory();
        this.flowNum_ = lexItem.GetFlowNumber();
        this.flowComponentNum_ = lexItem.GetFlowComponentNumber();
        this.tag_ = lexItem.GetTag();
        if (bl) {
            this.tarTerm_ = lexItem.GetTargetTerm();
            this.tarCategory_ = new Category(lexItem.GetTargetCategory().GetValue());
            this.tarInflection_ = new Inflection(lexItem.GetTargetInflection().GetValue());
            this.tarGender_ = new Gender(lexItem.GetTargetGender().GetValue());
            this.mutateInfo_ = lexItem.GetMutateInformation();
        }
    }

    public static LexItem TargetToSource(LexItem lexItem) {
        LexItem lexItem2 = new LexItem();
        lexItem2.SetOriginalTerm(lexItem.GetOriginalTerm());
        lexItem2.SetSourceTerm(lexItem.GetTargetTerm());
        lexItem2.SetSourceCategory(lexItem.GetTargetCategory().GetValue());
        lexItem2.SetSourceInflection(lexItem.GetTargetInflection().GetValue());
        lexItem2.SetDetailInformation(lexItem.GetDetailInformation());
        lexItem2.SetMutateInformation(lexItem.GetMutateInformation());
        lexItem2.SetFlowHistory(lexItem.GetFlowHistory());
        lexItem2.SetFlowNumber(lexItem.GetFlowNumber());
        lexItem2.SetFlowComponentNumber(lexItem.GetFlowComponentNumber() + 1);
        lexItem2.SetTag(lexItem.GetTag());
        return lexItem2;
    }

    public static Vector TargetsToSources(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            LexItem lexItem2 = LexItem.TargetToSource(lexItem);
            vector2.addElement(lexItem2);
            ++n;
        }
        return vector2;
    }

    public void SetOriginalTerm(String string) {
        this.orgTerm_ = string;
    }

    public void SetSourceTerm(String string) {
        this.srcTerm_ = string;
    }

    public void SetTargetTerm(String string) {
        this.tarTerm_ = string;
    }

    public void SetSourceCategory(long l) {
        this.srcCategory_.SetValue(l);
    }

    public void SetTargetCategory(long l) {
        this.tarCategory_.SetValue(l);
    }

    public void SetSourceInflection(long l) {
        this.srcInflection_.SetValue(l);
    }

    public void SetTargetInflection(long l) {
        this.tarInflection_.SetValue(l);
    }

    public void SetDetailInformation(String string) {
        this.detailInfo_ = string;
    }

    public void SetMutateInformation(String string) {
        this.mutateInfo_ = string;
    }

    public void SetTag(long l) {
        this.tag_ = l;
    }

    public void SetFlowHistory(String string) {
        this.flowHistory_ = string;
    }

    public void SetFlowNumber(int n) {
        this.flowNum_ = n;
    }

    public void SetFlowComponentNumber(int n) {
        this.flowComponentNum_ = n;
    }

    public String GetOriginalTerm() {
        return this.orgTerm_;
    }

    public String GetSourceTerm() {
        return this.srcTerm_;
    }

    public Gender GetSourceGender() {
        return this.srcGender_;
    }

    public String GetTargetTerm() {
        return this.tarTerm_;
    }

    public Category GetSourceCategory() {
        return this.srcCategory_;
    }

    public Category GetTargetCategory() {
        return this.tarCategory_;
    }

    public Inflection GetSourceInflection() {
        return this.srcInflection_;
    }

    public Inflection GetTargetInflection() {
        return this.tarInflection_;
    }

    public Gender GetTargetGender() {
        return this.tarGender_;
    }

    public String GetFlowHistory() {
        return this.flowHistory_;
    }

    public String GetDetailInformation() {
        return this.detailInfo_;
    }

    public long GetTag() {
        return this.tag_;
    }

    public String GetMutateInformation() {
        return this.mutateInfo_;
    }

    public int GetFlowNumber() {
        return this.flowNum_;
    }

    public int GetFlowComponentNumber() {
        return this.flowComponentNum_;
    }

    public static String GetResultString(LexItem lexItem, String string, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, String string2) {
        String string3 = string;
        if (bl4) {
            string3 = lexItem.GetOriginalTerm();
        }
        String string4 = lexItem.GetTargetTerm();
        switch (n) {
            case 2: {
                string4 = string4.toLowerCase();
                break;
            }
            case 3: {
                string4 = string4.toUpperCase();
            }
        }
        String string5 = Long.toString(lexItem.GetTargetCategory().GetValue());
        if (bl2) {
            string5 = "<" + lexItem.GetTargetCategory().GetName() + ">";
        }
        String string6 = Long.toString(lexItem.GetTargetInflection().GetValue());
        if (bl3) {
            string6 = "<" + lexItem.GetTargetInflection().GetName() + ">";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(string2);
        stringBuffer.append(string4);
        stringBuffer.append(string2);
        stringBuffer.append(string5);
        stringBuffer.append(string2);
        stringBuffer.append(string6);
        stringBuffer.append(string2);
        stringBuffer.append(lexItem.GetFlowHistory());
        stringBuffer.append(string2);
        stringBuffer.append(lexItem.GetFlowNumber());
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append(lexItem.GetMutateInformation());
        }
        String string7 = stringBuffer.toString();
        return string7;
    }

    public static void main(String[] stringArray) {
        LexItem lexItem;
        LexItem lexItem2 = new LexItem("Test");
        LexItem.PrintLexItem(lexItem2);
        LexItem lexItem3 = LexItem.TargetToSource(lexItem2);
        LexItem.PrintLexItem(lexItem3);
        Vector<LexItem> vector = new Vector<LexItem>();
        vector.addElement(lexItem2);
        vector.addElement(lexItem3);
        Vector vector2 = LexItem.TargetsToSources(vector);
        int n = 0;
        while (n < vector2.size()) {
            lexItem = (LexItem)vector2.elementAt(n);
            LexItem.PrintLexItem(lexItem);
            ++n;
        }
        try {
            lexItem = (LexItem)lexItem2.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void PrintLexItem(LexItem lexItem) {
        System.out.println("------------------------------------------------");
        System.out.println("Original Term: " + lexItem.GetOriginalTerm());
        System.out.println("Source Term: " + lexItem.GetSourceTerm());
        System.out.println("Source Category: " + lexItem.GetSourceCategory().GetValue());
        System.out.println("Source Inflection: " + lexItem.GetSourceInflection().GetValue());
        System.out.println("Target Term: " + lexItem.GetTargetTerm());
        System.out.println("Target Category: " + lexItem.GetTargetCategory().GetValue());
        System.out.println("Target Inflection: " + lexItem.GetTargetInflection().GetValue());
        System.out.println("Flow History: " + lexItem.GetFlowHistory());
        System.out.println("Detail Information: " + lexItem.GetDetailInformation());
        System.out.println("Mutate Information: " + lexItem.GetMutateInformation());
        System.out.println("Flow Number: " + lexItem.GetFlowNumber());
    }
}

