/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.CombineRecords;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Lib.LvgOutputOption;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class OutputFilter {
    public static final int NOT_DERIVATION = 0;
    public static final int LVG_ONLY = 1;
    public static final int LVG_OR_ALL = 2;
    public static final int ALL = 3;
    public static final int PRESERVED_CASE = 1;
    public static final int LOWERCASE = 2;
    public static final int UPPERCASE = 3;
    protected static final String HEAD = "<";
    protected static final String TAIL = ">";

    public static String ExecuteOutputFilter(Vector vector, boolean bl, boolean bl2, String string, String string2, LvgOutputOption lvgOutputOption) {
        Object object;
        Object object2;
        String string3 = new String();
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.size() == 0 && lvgOutputOption.GetNoOutputFlag()) {
            object2 = string2 + string + lvgOutputOption.GetNoOutputStr();
            object = OutputFilter.FieldFilter((String)object2, lvgOutputOption.GetOutputFieldList());
            stringBuffer.append((String)object);
            stringBuffer.append(System.getProperty("line.separator").toString());
        }
        try {
            Object object3;
            object2 = CombineRecords.Combine(vector, lvgOutputOption.GetCombineRule());
            if (lvgOutputOption.GetSortFlag() != 0) {
                object = new LexItemComparator();
                ((LexItemComparator)object).SetRule(lvgOutputOption.GetSortFlag());
                Collections.sort(object2, object);
            }
            int n = 0;
            long l = Bit.Minus(lvgOutputOption.GetOutCategory(), lvgOutputOption.GetExcludeCategory());
            long l2 = Bit.Minus(lvgOutputOption.GetOutInflection(), lvgOutputOption.GetExcludeInflection());
            int n2 = 0;
            while (n2 < ((Vector)object2).size()) {
                object3 = (LexItem)((Vector)object2).elementAt(n2);
                if (OutputFilter.IsCategoryInflectionOK((LexItem)object3, l, l2)) {
                    String string4 = LexItem.GetResultString((LexItem)object3, string2, bl, lvgOutputOption.GetCaseFlag(), lvgOutputOption.GetShowCategoryStrFlag(), lvgOutputOption.GetShowInflectionStrFlag(), lvgOutputOption.GetFilterInputFlag(), string);
                    String string5 = OutputFilter.FieldFilter(string4, lvgOutputOption.GetOutputFieldList());
                    stringBuffer.append(string5);
                    stringBuffer.append(GlobalBehavior.LS_STR);
                    ++n;
                    if (bl2) {
                        stringBuffer.append(((LexItem)object3).GetDetailInformation());
                        stringBuffer.append(GlobalBehavior.LS_STR);
                    }
                    if (lvgOutputOption.GetOutRecordNum() > 0 && n >= lvgOutputOption.GetOutRecordNum()) break;
                }
                ++n2;
            }
            if (lvgOutputOption.GetMarkEndFlag()) {
                object3 = lvgOutputOption.GetMarkEndStr();
                stringBuffer.append((String)object3);
                stringBuffer.append(GlobalBehavior.LS_STR);
            }
        }
        catch (Exception exception) {
            System.out.println("** Error in ExecuteOutoutFilter( ): " + exception.toString());
        }
        string3 = stringBuffer.toString();
        return string3;
    }

    public static Vector GetSimpleInflection(Vector vector) {
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            LexItem lexItem2 = OutputFilter.GetSimpleInflection(lexItem);
            if (lexItem2 != null) {
                vector2.addElement(lexItem2);
            }
            ++n;
        }
        return vector2;
    }

    public static Vector GetEnhancedSimpleInflection(Vector vector) {
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            LexItem lexItem2 = OutputFilter.GetEnhancedSimpleInflection(lexItem);
            if (lexItem2 != null) {
                vector2.addElement(lexItem2);
            }
            ++n;
        }
        return vector2;
    }

    public static LexItem GetSimpleInflection(LexItem lexItem) {
        Inflection inflection = lexItem.GetTargetInflection();
        long l = Bit.Minus(inflection.GetValue(), 0xFFFE00L);
        LexItem lexItem2 = null;
        if (l > 0L) {
            lexItem2 = new LexItem(lexItem, true);
            lexItem2.SetTargetInflection(l);
        }
        return lexItem2;
    }

    public static LexItem GetEnhancedSimpleInflection(LexItem lexItem) {
        Inflection inflection = lexItem.GetTargetInflection();
        long l = Bit.Minus(inflection.GetValue(), 0xFFFE00L);
        LexItem lexItem2 = null;
        long l2 = lexItem.GetTargetCategory().GetValue();
        if (l > 0L || l2 == Category.ToValue("aux") || l2 == Category.ToValue("modal")) {
            // empty if block
        }
        lexItem2 = new LexItem(lexItem, true);
        lexItem2.SetTargetInflection(l);
        return lexItem2;
    }

    public static boolean IsCategoryOK(LexItem lexItem, long l) {
        if (l == 2047L) {
            return true;
        }
        boolean bl = Bit.Contain(l, lexItem.GetTargetCategory().GetValue());
        return bl;
    }

    public static boolean IsCategoryInflectionOK(LexItem lexItem, long l, long l2) {
        if (l == 2047L && l2 == 0xFFFFFFL) {
            return true;
        }
        boolean bl = Bit.Contain(l, lexItem.GetTargetCategory().GetValue()) && Bit.Contain(l2, lexItem.GetTargetInflection().GetValue());
        return bl;
    }

    public static Vector RestrictOption(Vector vector, Vector vector2, int n) {
        Vector vector3 = new Vector();
        switch (n) {
            case 1: {
                vector3.addAll(vector);
                break;
            }
            case 3: {
                vector3.addAll(vector);
                vector3.addAll(vector2);
                break;
            }
            case 2: {
                vector3.addAll(vector);
                if (vector3.size() != 0) break;
                vector3.addAll(vector2);
            }
        }
        return vector3;
    }

    private static String ModifyCase(String string, int n) {
        String string2 = string;
        switch (n) {
            case 2: {
                string2 = string.toLowerCase();
                break;
            }
            case 3: {
                string2 = string.toUpperCase();
            }
        }
        return string2;
    }

    private static String FieldFilter(String string, Vector vector) {
        String string2 = GlobalBehavior.GetFieldSeparator();
        if (vector.size() == 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        Vector<String> vector2 = new Vector<String>();
        String string3 = new String();
        String string4 = new String();
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                if (string4.equals(string2)) {
                    vector2.addElement("");
                }
            } else {
                vector2.addElement(string3);
            }
            string4 = string3;
        }
        String string5 = new String();
        int n = 0;
        while (n < vector.size()) {
            int n2 = (Integer)vector.elementAt(n) - 1;
            string5 = n2 < vector2.size() ? string5 + (String)vector2.elementAt(n2) + string2 : string5 + string2;
            ++n;
        }
        string5 = string5.substring(0, string5.length() - 1);
        return string5;
    }
}

