/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.PersistentExceptionNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentRuleNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentTreeNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentTrieNode;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Trie.RuleResultComparator;
import gov.nih.nlm.nls.lvg.Trie.WildCard;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Vector;

public final class PersistentTrie {
    public static final long LEGAL_CATEGORY = 1155L;
    public static final long LEGAL_INFLECTION = 2099071L;
    public static final long LEGAL_BASE = 1793L;
    private Vector foundNodeList_ = null;
    private PersistentTrieNode root_ = null;
    private PersistentTrieNode foundNode_ = null;
    private RandomAccessFile trieRaf_ = null;
    private RandomAccessFile ruleRaf_ = null;
    private RandomAccessFile exceptionRaf_ = null;
    private int matchedNodeNum_ = 0;
    private int minTermLength_ = 2;
    private boolean isInflection_ = true;

    public PersistentTrie(boolean bl, int n, String string) {
        this.isInflection_ = bl;
        this.minTermLength_ = n;
        String string2 = string + "/data/rules/trieI.data";
        String string3 = string + "/data/rules/ruleI.data";
        String string4 = string + "/data/rules/exceptionI.data";
        if (!bl) {
            string2 = string + "/data/rules/trieD.data";
            string3 = string + "/data/rules/ruleD.data";
            string4 = string + "/data/rules/exceptionD.data";
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(string3, "r");
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(string4, "r");
            this.trieRaf_ = randomAccessFile;
            this.ruleRaf_ = randomAccessFile2;
            this.exceptionRaf_ = randomAccessFile3;
            this.root_ = (PersistentTrieNode)PersistentTrieNode.GetNode(this.trieRaf_, 0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PersistentTrie(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, RandomAccessFile randomAccessFile3, int n, boolean bl) {
        this.isInflection_ = bl;
        this.minTermLength_ = n;
        this.trieRaf_ = randomAccessFile;
        this.ruleRaf_ = randomAccessFile2;
        this.exceptionRaf_ = randomAccessFile3;
        try {
            this.root_ = (PersistentTrieNode)PersistentTrieNode.GetNode(this.trieRaf_, 0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void Close() {
        try {
            this.trieRaf_.close();
            this.ruleRaf_.close();
            this.exceptionRaf_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Vector GetUninflectedTermsByRules(String string, long l, long l2, boolean bl) {
        Vector vector = this.Mutate(string, bl, l, l2, 1155L, 1793L);
        RuleResultComparator ruleResultComparator = new RuleResultComparator();
        Collections.sort(vector, ruleResultComparator);
        return vector;
    }

    public CatInfl GetCatInflByRules(String string, long l, long l2) {
        Object object;
        Vector vector = new Vector();
        long l3 = 0L;
        long l4 = 0L;
        try {
            object = this.FindRule(string);
            this.matchedNodeNum_ = ((Vector)object).size();
            boolean bl = false;
            int n = 0;
            while (n < ((Vector)object).size()) {
                PersistentTrieNode persistentTrieNode = (PersistentTrieNode)((Vector)object).elementAt(n);
                long l5 = persistentTrieNode.GetRuleAddress();
                if (persistentTrieNode == null || l5 == -1L) {
                    System.out.println("** Error: null in TrieNode or it's rules");
                    break;
                }
                long l6 = l5;
                if (l6 != -1L) {
                    l6 += 12L;
                    while (l6 != -1L) {
                        PersistentRuleNode persistentRuleNode = (PersistentRuleNode)PersistentRuleNode.GetNode(this.ruleRaf_, l6);
                        InflectionRule inflectionRule = new InflectionRule(persistentRuleNode.GetRuleString());
                        if (!this.IsException(string, persistentRuleNode.GetExceptionAddress())) {
                            long l7 = inflectionRule.GetInCategory();
                            long l8 = inflectionRule.GetInInflection();
                            if (Bit.Contain(l, l7) && Bit.Contain(l2, l8)) {
                                l3 |= l7;
                                l4 |= l8;
                            }
                        }
                        l6 = persistentRuleNode.GetNext();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new CatInfl(l3, l4);
        return object;
    }

    public Vector GetCatInflsByRules(String string, long l, long l2) {
        Vector vector = new Vector();
        long l3 = 0L;
        long l4 = 0L;
        Vector<CatInfl> vector2 = new Vector<CatInfl>();
        try {
            Vector vector3 = this.FindRule(string);
            this.matchedNodeNum_ = vector3.size();
            boolean bl = false;
            int n = 0;
            while (n < vector3.size()) {
                PersistentTrieNode persistentTrieNode = (PersistentTrieNode)vector3.elementAt(n);
                long l5 = persistentTrieNode.GetRuleAddress();
                if (persistentTrieNode == null || l5 == -1L) {
                    System.out.println("** Error: null in TrieNode or it's rules");
                    break;
                }
                long l6 = l5;
                if (l6 != -1L) {
                    l6 += 12L;
                    while (l6 != -1L) {
                        PersistentRuleNode persistentRuleNode = (PersistentRuleNode)PersistentRuleNode.GetNode(this.ruleRaf_, l6);
                        InflectionRule inflectionRule = new InflectionRule(persistentRuleNode.GetRuleString());
                        if (!this.IsException(string, persistentRuleNode.GetExceptionAddress())) {
                            long l7 = inflectionRule.GetInCategory();
                            long l8 = inflectionRule.GetInInflection();
                            CatInfl catInfl = new CatInfl(l7, l8);
                            vector2.addElement(catInfl);
                        }
                        l6 = persistentRuleNode.GetNext();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector2;
    }

    public Vector GetInflectedTermsByRules(String string, long l, long l2, boolean bl) {
        Object object;
        Vector vector = this.Mutate(string, bl, l, l2, 1155L, 1793L);
        Vector vector2 = new Vector();
        String string2 = null;
        long l3 = -1L;
        int n = 0;
        while (n < vector.size()) {
            object = (RuleResult)vector.elementAt(n);
            String string3 = ((RuleResult)object).GetOutTerm();
            String string4 = ((RuleResult)object).GetRuleString();
            long l4 = Category.ToValue(((RuleResult)object).GetOutCategory());
            Vector vector3 = new Vector();
            if (l4 != l3 || !string3.equals(string2)) {
                vector3 = this.Mutate(string3, bl, l4, 2099071L, 1155L, 2099071L);
            }
            string2 = string3;
            l3 = l4;
            Vector vector4 = this.RemoveIllegalTerms(string3, vector3);
            vector2 = PersistentTrie.AddRusultsToInflectList(vector2, vector4);
            ++n;
        }
        object = new RuleResultComparator();
        Collections.sort(vector2, object);
        return vector2;
    }

    private Vector RemoveIllegalTerms(String string, Vector vector) {
        Vector<RuleResult> vector2 = new Vector<RuleResult>();
        int n = 0;
        while (n < vector.size()) {
            RuleResult ruleResult = (RuleResult)vector.elementAt(n);
            String string2 = ruleResult.GetOutTerm();
            String string3 = ruleResult.GetRuleString();
            long l = Inflection.ToValue(ruleResult.GetOutInflection());
            if (!Inflection.Contains(1793L, l) || string.equals(string2)) {
                vector2.addElement(ruleResult);
            }
            ++n;
        }
        return vector2;
    }

    public Vector GetDerivationsByRules(String string, long l, long l2, boolean bl) {
        Vector vector = this.Mutate(string, bl, l, l2, 1155L, 1793L);
        return vector;
    }

    public void PrintResults(Vector vector) {
        System.out.println("-- matchNodeList size: " + this.GetMatchedNodeNum());
        int n = 0;
        while (n < vector.size()) {
            RuleResult ruleResult = (RuleResult)vector.elementAt(n);
            System.out.println(ruleResult.GetInTerm() + " --> " + ruleResult.GetOutTerm() + " ... Rule: " + ruleResult.GetRuleString());
            ++n;
        }
    }

    public int GetMatchedNodeNum() {
        return this.matchedNodeNum_;
    }

    public void SetMinTermLength(int n) {
        this.minTermLength_ = n;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: java PersistentTrie <term> <-i/d> <-s>");
            System.out.println(" term: input term for testing");
            System.out.println(" -i/d: Get inflection/Derivation");
            System.out.println("   -s: mutate with all branch rules applied");
        } else {
            String string = stringArray[0];
            String string2 = "../data/rules/trieI.data";
            String string3 = "../data/rules/ruleI.data";
            String string4 = "../data/rules/exceptionI.data";
            boolean bl = true;
            if (stringArray[1].equals("-d")) {
                string2 = "../data/rules/trieD.data";
                string3 = "../data/rules/ruleD.data";
                string4 = "../data/rules/exceptionD.data";
                bl = false;
            }
            boolean bl2 = false;
            if (stringArray[2].equals("-s")) {
                bl2 = true;
            }
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(string3, "r");
                RandomAccessFile randomAccessFile3 = new RandomAccessFile(string4, "r");
                PersistentTrie persistentTrie = new PersistentTrie(randomAccessFile, randomAccessFile2, randomAccessFile3, 3, bl);
                if (bl) {
                    System.out.println("-------- Uninflected Terms ----------");
                    Vector vector = persistentTrie.GetUninflectedTermsByRules(string, 2047L, 0xFFFFFFL, true);
                    persistentTrie.PrintResults(vector);
                    System.out.println("-------- Inflected Terms ------------");
                    vector = persistentTrie.GetInflectedTermsByRules(string, 2047L, 0xFFFFFFL, true);
                    persistentTrie.PrintResults(vector);
                    System.out.println("------ Category & Inflection -----");
                    CatInfl catInfl = persistentTrie.GetCatInflByRules(string, 2047L, 0xFFFFFFL);
                    System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                    System.out.println("------ Categories & Inflections -----");
                    vector = persistentTrie.GetCatInflsByRules(string, 2047L, 0xFFFFFFL);
                    int n = 0;
                    while (n < vector.size()) {
                        catInfl = (CatInfl)vector.elementAt(n);
                        System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                        ++n;
                    }
                } else {
                    System.out.println("---------- Derivations -------------");
                    Vector vector = persistentTrie.GetDerivationsByRules(string, 2047L, 0xFFFFFFL, true);
                    persistentTrie.PrintResults(vector);
                }
                randomAccessFile.close();
                randomAccessFile2.close();
                randomAccessFile3.close();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private Vector Mutate(String string, boolean bl, long l, long l2, long l3, long l4) {
        Object object;
        int n;
        Vector<RuleResult> vector;
        Vector<RuleResult> vector2 = new Vector<RuleResult>();
        try {
            vector = this.FindRule(string);
            this.matchedNodeNum_ = vector.size();
            n = 0;
            int n2 = 0;
            while (n2 < this.matchedNodeNum_) {
                object = (PersistentTrieNode)vector.elementAt(n2);
                long l5 = ((PersistentTrieNode)object).GetRuleAddress();
                if (object == null || l5 == -1L) {
                    System.out.println("** Error: null in TrieNode or it's rules");
                    break;
                }
                long l6 = l5;
                if (l6 != -1L) {
                    l6 += 12L;
                    while (l6 != -1L) {
                        RuleResult ruleResult;
                        PersistentRuleNode persistentRuleNode = (PersistentRuleNode)PersistentRuleNode.GetNode(this.ruleRaf_, l6);
                        InflectionRule inflectionRule = new InflectionRule(persistentRuleNode.GetRuleString());
                        if (!this.IsException(string, persistentRuleNode.GetExceptionAddress()) && (ruleResult = this.ApplyRules(string, inflectionRule, l, l2, l3, l4)) != null) {
                            if (bl) {
                                vector2.add(ruleResult);
                            } else if (((PersistentTreeNode)object).GetLevel() > n) {
                                n = ((PersistentTreeNode)object).GetLevel();
                                vector2.removeAllElements();
                                vector2.add(ruleResult);
                            } else if (((PersistentTreeNode)object).GetLevel() == n) {
                                vector2.add(ruleResult);
                            }
                        }
                        l6 = persistentRuleNode.GetNext();
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isInflection_) {
            return vector2;
        }
        vector = new Vector<RuleResult>();
        n = 0;
        while (n < vector2.size()) {
            RuleResult ruleResult = (RuleResult)vector2.elementAt(n);
            object = ruleResult.GetOutTerm();
            if (((String)object).length() > this.minTermLength_ || ((String)object).equals(string)) {
                vector.addElement(ruleResult);
            }
            ++n;
        }
        return vector;
    }

    static Vector AddRusultsToInflectList(Vector vector, Vector vector2) {
        Vector<RuleResult> vector3 = new Vector<RuleResult>(vector);
        int n = 0;
        while (n < vector2.size()) {
            RuleResult ruleResult = (RuleResult)vector2.elementAt(n);
            if (!PersistentTrie.HasResultWithSameOut(vector3, ruleResult)) {
                vector3.addElement(ruleResult);
            }
            ++n;
        }
        return vector3;
    }

    private static boolean HasResultWithSameOut(Vector vector, RuleResult ruleResult) {
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            RuleResult ruleResult2 = (RuleResult)vector.elementAt(n);
            if (ruleResult2.GetOutTerm().equals(ruleResult.GetOutTerm()) && ruleResult2.GetOutCategoryAndInflection().equals(ruleResult.GetOutCategoryAndInflection())) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private Vector FindRule(String string) throws IOException {
        String string2 = string.trim() + '$';
        char[] cArray = string2.toCharArray();
        this.foundNodeList_ = new Vector();
        this.foundNodeList_.addElement(this.root_);
        this.FindNode(this.root_, cArray);
        return this.foundNodeList_;
    }

    private boolean IsException(String string, long l) throws IOException {
        boolean bl = false;
        long l2 = l;
        if (l2 != -1L) {
            l2 += 12L;
            while (l2 != -1L) {
                PersistentExceptionNode persistentExceptionNode = (PersistentExceptionNode)PersistentExceptionNode.GetNode(this.exceptionRaf_, l2);
                if (string.equals(persistentExceptionNode.GetKey())) {
                    bl = true;
                    break;
                }
                l2 = persistentExceptionNode.GetNext();
            }
        }
        return bl;
    }

    private RuleResult ApplyRules(String string, InflectionRule inflectionRule, long l, long l2, long l3, long l4) {
        String string2 = string + '$';
        String string3 = inflectionRule.GetInSuffix();
        String string4 = inflectionRule.GetOutSuffix();
        int n = string2.length();
        int n2 = string3.length();
        long l5 = Category.ToValue(inflectionRule.GetInCategoryStr());
        long l6 = Category.ToValue(inflectionRule.GetOutCategoryStr());
        long l7 = Inflection.ToValue(inflectionRule.GetInInflectionStr());
        long l8 = Inflection.ToValue(inflectionRule.GetOutInflectionStr());
        String string5 = string2.substring(0, n - n2);
        String string6 = WildCard.GetSuffix(string3, string4, string2);
        String string7 = string5 + string6;
        string7 = string7.substring(0, string7.length() - 1);
        RuleResult ruleResult = null;
        if (Category.Contains(l, l5) && Category.Contains(l3, l6) && Inflection.Contains(l2, l7) && Inflection.Contains(l4, l8)) {
            ruleResult = new RuleResult(string, string7, inflectionRule.GetRuleStr());
        }
        return ruleResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean FindNode(PersistentTrieNode persistentTrieNode, char[] cArray) throws IOException {
        char c = persistentTrieNode.GetKey();
        int n = persistentTrieNode.GetLevel();
        int n2 = Array.getLength(cArray);
        int n3 = n2 - 1 - n;
        if (!WildCard.IsMatchKey(c, n3, cArray)) return false;
        long l = persistentTrieNode.GetRuleAddress();
        if (l != -1L) {
            this.foundNode_ = persistentTrieNode;
            this.AddNodeToFoundList();
        }
        if (n3 == 0) {
            return true;
        }
        boolean bl = false;
        if (persistentTrieNode.GetChild() == -1L) return true;
        long l2 = persistentTrieNode.GetChild();
        while (l2 != -1L) {
            PersistentTrieNode persistentTrieNode2 = (PersistentTrieNode)PersistentTrieNode.GetNode(this.trieRaf_, l2);
            if (this.FindNode(persistentTrieNode2, cArray)) {
                bl = true;
            }
            l2 = persistentTrieNode2.GetNext();
        }
        if (!bl) return true;
        this.AddNodeToFoundList();
        return true;
    }

    private void AddNodeToFoundList() {
        boolean bl = false;
        int n = 0;
        while (n < this.foundNodeList_.size()) {
            if (this.foundNode_ == (PersistentTrieNode)this.foundNodeList_.elementAt(n)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.foundNodeList_.addElement(this.foundNode_);
        }
    }
}

