/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.RuleException;
import gov.nih.nlm.nls.lvg.Trie.TrieNode;
import gov.nih.nlm.nls.lvg.Trie.WildCard;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TrieTree {
    private boolean wildCard_ = false;
    private TrieNode root_ = null;
    private TrieNode curNode_ = null;
    private TrieNode foundNode_ = null;
    private Vector foundNodeList_ = null;
    private int nodeNum_ = 1;
    private int ruleNum_ = 0;
    private int exceptionNum_ = 0;
    private boolean firstTime_ = true;
    private InflectionRule curRule_ = null;
    private static final String RULE = "RULE: ";
    private static final String EXCEPTION = "EXCEPTION: ";
    private static final String FILE = "FILE: ";

    public TrieTree() {
        this.root_ = new TrieNode('$', 0);
    }

    public TrieTree(boolean bl) {
        this.wildCard_ = bl;
        this.root_ = new TrieNode('$', 0);
    }

    public void SetWildCard(boolean bl) {
        this.wildCard_ = bl;
    }

    public void LoadRulesFromFile(String string, String string2, boolean bl, boolean bl2) {
        if (string2 == null || string == null) {
            return;
        }
        String string3 = string + string2;
        try {
            String string4 = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
            while ((string4 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (string4.length() <= 0) continue;
                if (string4.startsWith(EXCEPTION)) {
                    stringTokenizer = new StringTokenizer(string4, " ");
                    stringTokenizer.nextToken();
                    string4 = this.ReverseException(stringTokenizer.nextToken(), bl);
                    this.curRule_.AddException(string4);
                    ++this.exceptionNum_;
                    continue;
                }
                if (string4.startsWith(RULE)) {
                    stringTokenizer = new StringTokenizer(string4, " ");
                    stringTokenizer.nextToken();
                    string4 = this.ReverseRule(stringTokenizer.nextToken(), bl);
                    this.AddRule(string4, bl2);
                    continue;
                }
                if (!string4.startsWith(FILE)) continue;
                stringTokenizer = new StringTokenizer(string4, " ");
                stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                this.LoadRulesFromFile(string, string5, bl, bl2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
            System.out.println("**Error: problem of opening/reading file '" + string3 + "'.");
        }
    }

    public Vector FindRule(String string) {
        String string2 = string.trim() + '$';
        char[] cArray = string2.toCharArray();
        this.foundNodeList_ = new Vector();
        this.foundNodeList_.addElement(this.root_);
        this.FindNode(this.root_, cArray);
        return this.foundNodeList_;
    }

    public void PrintTrie(boolean bl, boolean bl2, boolean bl3) {
        this.PrintTrie(this.root_, bl, bl2, bl3);
    }

    public TrieNode GetRoot() {
        return this.root_;
    }

    public static void main(String[] stringArray) {
        TrieTree trieTree = new TrieTree();
        trieTree.SetWildCard(true);
        trieTree.LoadRulesFromFile("../../data/rules/", "im.rul", false, false);
        System.out.println("----- result ---------");
        trieTree.PrintTrie(trieTree.GetRoot(), true, true, true);
    }

    private String ReverseException(String string, boolean bl) {
        String string2 = string;
        if (bl) {
            RuleException ruleException = new RuleException(string);
            ruleException.Reverse();
            string2 = ruleException.GetExceptionStr();
        }
        return string2;
    }

    private String ReverseRule(String string, boolean bl) {
        String string2 = string;
        if (bl) {
            InflectionRule inflectionRule = new InflectionRule(string);
            inflectionRule.Reverse();
            string2 = inflectionRule.GetRuleStr();
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean FindNode(TrieNode trieNode, char[] cArray) {
        char c = trieNode.GetKey();
        int n = trieNode.GetLevel();
        int n2 = Array.getLength(cArray);
        int n3 = n2 - 1 - n;
        if (!WildCard.IsMatchKey(c, n3, cArray)) return false;
        if (trieNode.GetRules() != null) {
            this.foundNode_ = trieNode;
            this.AddNodeToFoundList();
        }
        if (n3 == 0) {
            return true;
        }
        boolean bl = false;
        if (trieNode.GetChild() == null) return true;
        int n4 = 0;
        while (n4 < trieNode.GetChild().size()) {
            TrieNode trieNode2 = (TrieNode)trieNode.GetChild().elementAt(n4);
            if (this.FindNode(trieNode2, cArray)) {
                bl = true;
            }
            ++n4;
        }
        if (!bl) return true;
        this.AddNodeToFoundList();
        return true;
    }

    private void AddNodeToFoundList() {
        boolean bl = false;
        int n = 0;
        while (n < this.foundNodeList_.size()) {
            if (this.foundNode_ == (TrieNode)this.foundNodeList_.elementAt(n)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.foundNodeList_.addElement(this.foundNode_);
        }
    }

    private void AddRule(String string, boolean bl) {
        int n;
        this.curRule_ = new InflectionRule(string);
        String string2 = this.curRule_.GetInSuffix();
        char c = ' ';
        this.curNode_ = this.root_;
        int n2 = string2.length() - 1 - 1;
        while (n2 >= 0) {
            c = string2.charAt(n2);
            n = string2.length() - 1 - n2;
            this.AddTrieNode(c, n);
            --n2;
        }
        if (this.curNode_.GetRules() == null) {
            Vector<InflectionRule> vector = new Vector<InflectionRule>();
            vector.addElement(this.curRule_);
            this.curNode_.SetRules(vector);
            ++this.ruleNum_;
        } else {
            n = 0;
            int n3 = 0;
            while (n3 < this.curNode_.GetRules().size()) {
                InflectionRule inflectionRule = (InflectionRule)this.curNode_.GetRules().elementAt(n3);
                if (this.curRule_.equals(inflectionRule)) {
                    if (bl) {
                        System.out.println("* Warning: duplicate rule (" + this.curRule_.GetRuleStr() + ")");
                    }
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                int n4;
                int n5 = n4 = this.curNode_.GetRules().size();
                long l = this.curRule_.GetInCategory();
                int n6 = 0;
                while (n6 < this.curNode_.GetRules().size()) {
                    InflectionRule inflectionRule = (InflectionRule)this.curNode_.GetRules().elementAt(n6);
                    if (this.GetDistance(l, inflectionRule.GetInCategory()) > 0) {
                        n5 = n6;
                        break;
                    }
                    ++n6;
                }
                this.curNode_.GetRules().add(n5, this.curRule_);
                ++this.ruleNum_;
            }
        }
    }

    private int GetDistance(long l, long l2) {
        int n = this.ToPriority(l);
        int n2 = this.ToPriority(l2);
        int n3 = n2 - n;
        return n3;
    }

    private int ToPriority(long l) {
        int n = 0;
        if (l == Category.ToValue("noun")) {
            n = 1;
        } else if (l == Category.ToValue("verb")) {
            n = 2;
        } else if (l == Category.ToValue("adj")) {
            n = 3;
        } else if (l == Category.ToValue("adv")) {
            n = 4;
        }
        return n;
    }

    private void AddTrieNode(char c, int n) {
        char c2 = this.curNode_.GetKey();
        if (this.curNode_ != null) {
            TrieNode trieNode;
            if (this.curNode_.GetChild() == null) {
                this.curNode_.SetChild(new Vector());
            }
            boolean bl = false;
            Vector vector = this.curNode_.GetChild();
            int n2 = 0;
            while (n2 < vector.size()) {
                trieNode = (TrieNode)vector.elementAt(n2);
                if (c == trieNode.GetKey()) {
                    this.curNode_ = trieNode;
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                trieNode = new TrieNode(c, n);
                this.InsertNode(this.curNode_.GetChild(), trieNode);
                this.curNode_ = trieNode;
                ++this.nodeNum_;
            }
        }
    }

    private void InsertNode(Vector vector, TrieNode trieNode) {
        int n = this.FindIndex(vector, trieNode);
        vector.insertElementAt(trieNode, n);
    }

    private int FindIndex(Vector vector, TrieNode trieNode) {
        int n;
        int n2 = n = vector.size();
        char c = trieNode.GetKey();
        int n3 = 0;
        while (n3 < n) {
            TrieNode trieNode2 = (TrieNode)vector.elementAt(n3);
            if (trieNode2.GetKey() >= c) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    private void PrintTrie(TrieNode trieNode, boolean bl, boolean bl2, boolean bl3) {
        Vector vector;
        int n;
        int n2;
        if (this.firstTime_) {
            this.firstTime_ = false;
            System.out.println("======== Trie Tree Information =========");
            System.out.println("Number of nodes: " + this.nodeNum_);
            System.out.println("Number of rules: " + this.ruleNum_);
            System.out.println("Number of exceptions: " + this.exceptionNum_);
            System.out.println("----------------------------------------");
        }
        System.out.print("--");
        int n3 = 0;
        while (n3 < trieNode.GetLevel()) {
            System.out.print("---");
            ++n3;
        }
        System.out.print(trieNode.GetKey());
        if (bl) {
            n2 = trieNode.GetChild() == null ? 0 : trieNode.GetChild().size();
            n = trieNode.GetRules() == null ? 0 : trieNode.GetRules().size();
            System.out.print(" (child: " + n2 + "; rule: " + n + ")");
        }
        System.out.print(System.getProperty("line.separator").toString());
        if (bl2 && (vector = trieNode.GetRules()) != null) {
            n = 0;
            while (n < vector.size()) {
                Hashtable hashtable;
                InflectionRule inflectionRule = (InflectionRule)vector.elementAt(n);
                System.out.print("  ");
                int n4 = 0;
                while (n4 < trieNode.GetLevel()) {
                    System.out.print("   ");
                    ++n4;
                }
                System.out.print("R-" + n + ": '" + inflectionRule.GetRuleStr() + "'");
                int n5 = inflectionRule.GetExceptions() == null ? 0 : inflectionRule.GetExceptions().size();
                System.out.println(" (Exceptions: " + n5 + ")");
                if (bl3 && (hashtable = inflectionRule.GetExceptions()) != null) {
                    Enumeration enumeration = hashtable.keys();
                    Enumeration enumeration2 = hashtable.elements();
                    int n6 = 0;
                    while (enumeration.hasMoreElements()) {
                        System.out.print("      ");
                        int n7 = 0;
                        while (n7 < trieNode.GetLevel()) {
                            System.out.print("   ");
                            ++n7;
                        }
                        String string = (String)enumeration.nextElement();
                        String string2 = (String)enumeration2.nextElement();
                        System.out.println("E-" + n6 + ": '" + string + "' => '" + string2 + "'");
                        ++n6;
                    }
                }
                ++n;
            }
        }
        if (trieNode.GetChild() != null) {
            n2 = 0;
            while (n2 < trieNode.GetChild().size()) {
                TrieNode trieNode2 = (TrieNode)trieNode.GetChild().elementAt(n2);
                this.PrintTrie(trieNode2, bl, bl2, bl3);
                ++n2;
            }
        }
    }
}

