/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.lang.reflect.Array;
import java.util.HashSet;

public final class WildCard {
    public static final char VOWEL = 'V';
    public static final char CONSONANT = 'C';
    public static final char SAME_AS_PREV = 'S';
    public static final char DIGIT = 'D';
    public static final char LETTER = 'L';
    public static final char BEGIN = '^';
    public static final char END = '$';
    public static final char FS = '|';
    private static HashSet vowelWildCardSet_ = new HashSet();
    private static HashSet consonantWildCardSet_ = new HashSet();
    private static HashSet wildCardSet_ = new HashSet();
    private static HashSet vowelSet_ = new HashSet();
    private static HashSet consonantSet_ = new HashSet();
    private static HashSet digitSet_ = new HashSet();
    private static HashSet letterSet_ = new HashSet();

    private WildCard() {
    }

    public static String GetSuffix(String string, String string2, String string3) {
        int n = string3.length();
        int n2 = string.length();
        String string4 = string3.substring(n - n2);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            if (WildCard.IsLegalWildCard(c) && c != '$') {
                if (n3 >= string.length() - 1) {
                    stringBuffer.append(string4.charAt(string4.length() - 2));
                } else {
                    stringBuffer.append(string4.charAt(n3));
                }
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static boolean IsMatchKey(char c, int n, char[] cArray) {
        boolean bl = false;
        if (WildCard.IsWildCard(c) && !WildCard.IsLegalWildCard(c)) {
            return false;
        }
        char c2 = cArray[n];
        String string = String.valueOf(c2);
        if (c == cArray[n]) {
            bl = true;
        } else if (c == 'V' && vowelSet_.contains(string)) {
            bl = true;
        } else if (c == 'C' && consonantSet_.contains(string)) {
            bl = true;
        } else if (c == 'S' && n < Array.getLength(cArray) - 1 && c2 == cArray[n + 1]) {
            bl = true;
        } else if (c == 'D' && Character.isDigit(c2)) {
            bl = true;
        } else if (c == 'L' && Character.isLetter(c2) && Character.isLowerCase(c2)) {
            bl = true;
        } else if (c == '$' && n == Array.getLength(cArray) - 1) {
            bl = true;
        } else if (c == '^' && n == -1) {
            bl = true;
        }
        return bl;
    }

    public static char WildCardTransform(char n) {
        String string = String.valueOf((char)n);
        int n2 = n;
        if (vowelWildCardSet_.contains(string)) {
            n2 = 86;
        } else if (consonantWildCardSet_.contains(string)) {
            n2 = 67;
        }
        return (char)n2;
    }

    public static String WildCardTransform(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = ' ';
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            char c2 = stringBuffer.charAt(n);
            if (WildCard.IsWildCard(c2)) {
                if (c2 == c) {
                    stringBuffer.setCharAt(n, 'S');
                } else {
                    stringBuffer.setCharAt(n, WildCard.WildCardTransform(c2));
                }
            }
            c = string.charAt(n);
            --n;
        }
        return stringBuffer.toString();
    }

    public static boolean IsWildCard(char c) {
        boolean bl = Character.isLetter(c) && !Character.isLowerCase(c);
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = "CEXXer$|adj|comparative|CEX$|adj|positive";
        System.out.println("in:  '" + string + "'");
        System.out.println("out: '" + WildCard.WildCardTransform(string) + "'");
        System.out.println("-----------------------");
        string = "|CUAB|BDDer|ARRRRT|arrrrt";
        System.out.println("in:  '" + string + "'");
        System.out.println("out: '" + WildCard.WildCardTransform(string) + "'");
        System.out.println("-----------------------");
        System.out.println("IsLegalWildCard('A'): " + WildCard.IsLegalWildCard('A'));
        System.out.println("IsLegalWildCard('S'): " + WildCard.IsLegalWildCard('S'));
    }

    private static boolean IsLegalWildCard(char c) {
        String string = String.valueOf(c);
        return wildCardSet_.contains(string);
    }

    static {
        vowelWildCardSet_.add("A");
        vowelWildCardSet_.add("E");
        vowelWildCardSet_.add("I");
        vowelWildCardSet_.add("O");
        vowelWildCardSet_.add("U");
        consonantWildCardSet_.add("B");
        consonantWildCardSet_.add("C");
        consonantWildCardSet_.add("F");
        consonantWildCardSet_.add("G");
        consonantWildCardSet_.add("H");
        consonantWildCardSet_.add("J");
        consonantWildCardSet_.add("K");
        consonantWildCardSet_.add("M");
        consonantWildCardSet_.add("N");
        consonantWildCardSet_.add("P");
        consonantWildCardSet_.add("Q");
        consonantWildCardSet_.add("R");
        consonantWildCardSet_.add("T");
        consonantWildCardSet_.add("V");
        consonantWildCardSet_.add("W");
        consonantWildCardSet_.add("X");
        consonantWildCardSet_.add("Y");
        consonantWildCardSet_.add("Z");
        wildCardSet_.add(new Character('V').toString());
        wildCardSet_.add(new Character('C').toString());
        wildCardSet_.add(new Character('S').toString());
        wildCardSet_.add(new Character('D').toString());
        wildCardSet_.add(new Character('L').toString());
        wildCardSet_.add(new Character('^').toString());
        wildCardSet_.add(new Character('$').toString());
        vowelSet_.add("a");
        vowelSet_.add("e");
        vowelSet_.add("i");
        vowelSet_.add("o");
        vowelSet_.add("u");
        consonantSet_.add("b");
        consonantSet_.add("c");
        consonantSet_.add("d");
        consonantSet_.add("f");
        consonantSet_.add("g");
        consonantSet_.add("h");
        consonantSet_.add("j");
        consonantSet_.add("k");
        consonantSet_.add("l");
        consonantSet_.add("m");
        consonantSet_.add("n");
        consonantSet_.add("p");
        consonantSet_.add("q");
        consonantSet_.add("r");
        consonantSet_.add("s");
        consonantSet_.add("t");
        consonantSet_.add("v");
        consonantSet_.add("w");
        consonantSet_.add("x");
        consonantSet_.add("y");
        consonantSet_.add("z");
        letterSet_ = new HashSet(consonantSet_);
        letterSet_.add("a");
        letterSet_.add("e");
        letterSet_.add("i");
        letterSet_.add("o");
        letterSet_.add("u");
    }
}

