/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import gov.nih.nlm.nls.lvg.Util.StrTokenObject;
import java.util.StringTokenizer;
import java.util.Vector;

public class StripToken {
    private static final StrTokenObject SPACE_DELIM = new StrTokenObject(" ", 2);

    public static Vector Tokenize(String string) {
        return StripToken.Tokenize(string, "({[<\"'", ")}]>!?", ",.:;", " \t");
    }

    public static Vector Tokenize(String string, String string2, String string3, String string4, String string5) {
        Vector<StrTokenObject> vector = new Vector<StrTokenObject>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string5);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            Vector vector2 = StripToken.Tokenize(string6, string2, string3, string4);
            vector.addAll(vector2);
            vector.addElement(SPACE_DELIM);
        }
        int n = vector.size() - 1;
        if (n >= 0) {
            vector.remove(n);
        }
        return vector;
    }

    public static Vector Tokenize(String string, String string2, String string3, String string4) {
        Vector vector = new Vector();
        String string5 = string2 + string3 + string4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string5, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            if (string2.indexOf(string6) != -1) {
                StripToken.AddToList(string6, 4, vector);
                continue;
            }
            if (string3.indexOf(string6) != -1) {
                StripToken.AddToList(string6, 5, vector);
                continue;
            }
            if (string4.indexOf(string6) != -1) {
                StripToken.AddToList(string6, 6, vector);
                continue;
            }
            StripToken.AddToList(string6, 1, vector);
        }
        return vector;
    }

    public static Vector CleanUpToken(Vector vector) {
        return StripToken.CleanUpToken(vector, " -,:;");
    }

    public static Vector CleanUpToken(Vector vector, String string) {
        Vector<StrTokenObject> vector2 = new Vector<StrTokenObject>();
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            StrTokenObject strTokenObject = (StrTokenObject)vector.elementAt(n2);
            String string2 = strTokenObject.GetTokenStr();
            int n3 = strTokenObject.GetTokenType();
            switch (n3) {
                case 1: {
                    vector2.addElement(strTokenObject);
                    n = n3;
                    break;
                }
                case 2: {
                    if (n != 1 && n != 4 && n != 5 && n != 6) break;
                    vector2.addElement(strTokenObject);
                    n = n3;
                    break;
                }
                case 3: {
                    n = n3;
                    break;
                }
                case 4: {
                    vector2.addElement(strTokenObject);
                    n = n3;
                    break;
                }
                case 5: {
                    if (vector2.size() > 0) {
                        int n4 = vector2.size() - 1;
                        StrTokenObject strTokenObject2 = (StrTokenObject)vector2.elementAt(n4);
                        int n5 = strTokenObject2.GetTokenType();
                        String string3 = strTokenObject2.GetTokenStr();
                        while (n5 == 3 || string3.length() == 1 && string.indexOf(string3.charAt(0)) != -1) {
                            vector2.remove(n4);
                            n4 = vector2.size() - 1;
                            strTokenObject2 = (StrTokenObject)vector2.elementAt(n4);
                            string3 = strTokenObject2.GetTokenStr();
                            n5 = strTokenObject2.GetTokenType();
                        }
                    }
                    vector2.addElement(strTokenObject);
                    n = n3;
                    break;
                }
                case 6: {
                    if (n == 3) break;
                    vector2.addElement(strTokenObject);
                    n = n3;
                }
            }
            ++n2;
        }
        return vector2;
    }

    public static Vector CleanUpEnd(Vector vector) {
        return StripToken.CleanUpEnd(vector, " -,:;");
    }

    public static Vector CleanUpEnd(Vector vector, String string) {
        Vector vector2 = new Vector(vector);
        if (vector2.size() > 0) {
            int n = vector2.size() - 1;
            StrTokenObject strTokenObject = (StrTokenObject)vector2.elementAt(n);
            String string2 = strTokenObject.GetTokenStr();
            while (string2.length() == 1 && string.indexOf(string2.charAt(0)) != -1) {
                vector2.remove(n);
                n = vector2.size() - 1;
                strTokenObject = (StrTokenObject)vector2.elementAt(n);
                string2 = strTokenObject.GetTokenStr();
            }
        }
        return vector2;
    }

    public static String ComposeString(Vector vector) {
        String string = new String();
        int n = 0;
        while (n < vector.size()) {
            StrTokenObject strTokenObject = (StrTokenObject)vector.elementAt(n);
            string = string + strTokenObject.GetTokenStr();
            ++n;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("** Usage: java Str <inWord>");
        } else {
            String string = stringArray[0];
            Vector vector = StripToken.Tokenize(string);
            System.out.println("---------------------------------------------");
            System.out.println("in:  '" + string + "'");
            System.out.println("out: '" + StripToken.ComposeString(vector) + "'");
            Vector vector2 = StripToken.CleanUpToken(vector);
            System.out.println("new: '" + StripToken.ComposeString(vector2) + "'");
        }
    }

    private static void AddToList(String string, int n, Vector vector) {
        if (string != null) {
            StrTokenObject strTokenObject = new StrTokenObject(string, n);
            vector.addElement(strTokenObject);
        }
    }

    private static void PrintTokenVector(Vector vector) {
        System.out.println("===============================================");
        int n = 0;
        while (n < vector.size()) {
            StrTokenObject strTokenObject = (StrTokenObject)vector.elementAt(n);
            System.out.println(n + ": [" + strTokenObject.GetTokenType() + "]-[" + strTokenObject.GetTokenStr() + "]");
            ++n;
        }
    }
}

