/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import gov.nih.nlm.nls.lvg.Lib.Category;
import java.util.StringTokenizer;

public class XeroxParc {
    private String tagger_ = null;
    private String term_ = null;
    private String category_ = null;
    private long categoryValue_ = 0L;
    private boolean legal_ = true;

    public XeroxParc(String string) {
        this.tagger_ = string;
        this.DecomposeTagger(this.tagger_);
    }

    public boolean IsLegal() {
        if (this.term_ == null || this.category_ == null) {
            return false;
        }
        return this.legal_;
    }

    public String GetTerm() {
        return this.term_;
    }

    public String GetCategory() {
        return this.category_;
    }

    public long GetCategoryValue() {
        return this.categoryValue_;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("** Usage: java XeroxParc <tag>");
        } else {
            String string = stringArray[0];
            System.out.println("-- tagger: '" + string + "'");
            XeroxParc xeroxParc = new XeroxParc(string);
            System.out.println("-- term: [" + xeroxParc.GetTerm() + "]");
            System.out.println("-- category: [" + xeroxParc.GetCategory() + "]");
            System.out.println("-- categoryValue: [" + xeroxParc.GetCategoryValue() + "]");
        }
    }

    private void DecomposeTagger(String string) {
        this.legal_ = this.IsLegalXeroxParcFormat(string);
        if (!this.legal_) {
            return;
        }
        String string2 = "[',]";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        this.term_ = null;
        this.category_ = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3 == null) continue;
            if (this.term_ == null) {
                this.term_ = string3;
                continue;
            }
            if (this.category_ != null || Category.ToValue(string3) == 0L) continue;
            this.category_ = string3;
            this.categoryValue_ = Category.ToValue(this.category_);
            break;
        }
    }

    private boolean IsLegalXeroxParcFormat(String string) {
        boolean bl = true;
        if (!string.startsWith("[") || !string.endsWith("]")) {
            return false;
        }
        return bl;
    }
}

