/*
 * Decompiled with CFR 0.152.
 */
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Util.In;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class norm
extends SystemOption {
    private static final String NO_OUTPUT_STR = "-No Output-";
    private static boolean detailsFlag_ = false;
    private static boolean runFlag_ = true;
    private static boolean noOutputFlag_ = false;
    private static boolean promptFlag_ = false;
    private static boolean filterInputFlag_ = false;
    private static String separator_ = GlobalBehavior.GetFieldSeparator();
    private static BufferedReader inReader_ = null;
    private static BufferedWriter outWriter_ = null;
    private static int termFieldNum_ = 1;
    private static Connection conn_ = null;
    private static RamTrie trie_ = null;
    private static String configFile_ = null;
    private static String promptStr_ = null;
    private static Configuration conf_ = null;
    private static int maxTerm_ = -1;
    private static Vector stopWords_ = null;

    public static void main(String[] stringArray) {
        norm norm2;
        String string = "";
        Option option = new Option(string);
        if (stringArray.length > 0) {
            string = "";
            int n = 0;
            while (n < stringArray.length) {
                string = n == 0 ? stringArray[n] : string + " " + stringArray[n];
                ++n;
            }
            option = new Option(string);
        }
        if (SystemOption.CheckSyntax(option, (norm2 = new norm()).GetOption(), false, true)) {
            norm2.ExecuteCommands(option, norm2.GetOption());
            boolean bl = false;
            if (configFile_ == null) {
                bl = true;
                configFile_ = "data.config.lvg";
            }
            if (conf_ == null) {
                conf_ = new Configuration(configFile_, bl);
            }
            if (maxTerm_ == -1) {
                maxTerm_ = Integer.parseInt(conf_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
            }
            if (stopWords_ == null) {
                stopWords_ = ToStripStopWords.GetStopWordsFromFile(conf_);
            }
            promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
            if (!conf_.GetConfiguration("LVG_PROMPT").equals("DEFAULT")) {
                promptStr_ = conf_.GetConfiguration("LVG_PROMPT");
            }
            if (runFlag_) {
                norm.GetVariants();
            }
        } else {
            NormHelp.NormHelp();
        }
    }

    public static void GetVariants() {
        int n = Integer.parseInt(conf_.GetConfiguration("MIN_TERM_LENGTH"));
        String string = conf_.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(conf_.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        if (inReader_ == null) {
            inReader_ = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            conn_ = DbBase.OpenConnection(conf_);
            trie_ = new RamTrie(true, n, string, n2);
            do {
                if (!promptFlag_) continue;
                norm.GetPrompt();
            } while (norm.LineHandler(inReader_.readLine()));
            norm.Close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void ExecuteCommand(OptionItem optionItem, Option option) {
        OptionItem optionItem2 = OptionUtility.GetItemByName(optionItem, option, false);
        Vector vector = option.GetOptionItems();
        if (SystemOption.CheckOption(optionItem2, "-d")) {
            detailsFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-h")) {
            NormHelp.NormHelp();
            runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-hs")) {
            option.PrintOptionHierachy();
            runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-i:STR")) {
            String string = optionItem2.GetOptionArgument();
            if (string != null) {
                try {
                    inReader_ = new BufferedReader(new FileReader(string));
                }
                catch (IOException iOException) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + string);
                }
            }
        } else if (SystemOption.CheckOption(optionItem2, "-n")) {
            noOutputFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-o:STR")) {
            String string = optionItem2.GetOptionArgument();
            if (string != null) {
                try {
                    outWriter_ = new BufferedWriter(new FileWriter(string));
                }
                catch (IOException iOException) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + string);
                }
            }
        } else if (SystemOption.CheckOption(optionItem2, "-p")) {
            promptFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-s:STR")) {
            separator_ = optionItem2.GetOptionArgument();
        } else if (SystemOption.CheckOption(optionItem2, "-t:INT")) {
            termFieldNum_ = Integer.parseInt(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-ti")) {
            filterInputFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-v")) {
            try {
                Out.Println(outWriter_, "norm.2003", false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-x:STR")) {
            configFile_ = optionItem2.GetOptionArgument();
        }
    }

    protected void DefineFlag() {
        String string = "-d -h -hs -i:STR -n -o:STR -p -s:STR -t:INT -ti -v -x:STR";
        this.systemOption_ = new Option(string);
        this.systemOption_.SetFlagFullName("-d", "Print_Operation_Details");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-s", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t", "Term_Field");
        this.systemOption_.SetFlagFullName("-ti", "Display_Filtered_Input");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x", "Load_Configuration_file");
    }

    private static void Close() throws IOException, SQLException {
        if (outWriter_ != null) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
        if (conn_ != null) {
            DbBase.CloseConnection(conn_);
        }
    }

    private static void GetPrompt() throws IOException {
        Out.Println(outWriter_, promptStr_, false);
    }

    private static boolean LineHandler(String string) throws SQLException, IOException {
        if (string == null) {
            return false;
        }
        String string2 = In.GetField(string, separator_, termFieldNum_);
        LexItem lexItem = new LexItem(string2);
        Vector vector = ToNormalize.Mutate(lexItem, maxTerm_, stopWords_, conn_, trie_, detailsFlag_, false);
        if (vector.size() == 0) {
            if (noOutputFlag_) {
                Out.Println(outWriter_, string + separator_ + NO_OUTPUT_STR, false);
            }
        } else {
            int n = 0;
            while (n < vector.size()) {
                LexItem lexItem2 = (LexItem)vector.elementAt(n);
                String string3 = string;
                if (filterInputFlag_) {
                    string3 = lexItem2.GetOriginalTerm();
                }
                Out.Println(outWriter_, string3 + separator_ + lexItem2.GetTargetTerm(), false);
                if (detailsFlag_) {
                    Out.Println(outWriter_, lexItem2.GetDetailInformation(), false);
                }
                ++n;
            }
        }
        return true;
    }
}

