; -*- clips -*-

;; Jess standard script library
;; You can add functions to this file and they will be loaded in whenever
;; Jess starts up
;; (C) 1997 E.J.Friedman-Hill and Sandia National Laboratories

(deffunction show-deftemplates ()
  "Print deftemplates using Java reflection"
  (bind ?__e (call (engine) listDeftemplates))
  (while (call ?__e hasNext)    
    (printout t crlf (call (call ?__e next) toString) crlf)))

(deffunction show-jess-listeners ()
  "Print JessListeners using Java reflection"
  (bind ?__e (call (engine) listJessListeners))
  (while (call ?__e hasNext)    
    (printout t crlf (call (call ?__e next) toString) crlf)))

(deffunction show-deffacts ()
  "Print deffacts using Java reflection"
  (bind ?__e (call (engine) listDeffacts))
  (while (call ?__e hasNext)    
    (printout t crlf (call (call ?__e next) toString) crlf)))

(deffunction ppdefrule (?__rule)
  "Pretty-print a Jess rule"
  (bind ?__rule (call (engine) findDefrule ?__rule))
  (printout t (call ?__rule toString) crlf))

(deffunction ppdeffunction (?__function)
  "Pretty-print a Jess function"
  (bind ?__function (call (engine) findUserfunction ?__function))
  (printout t (call ?__function toString) crlf))

(deffunction ppdefglobal (?__global)
  "Pretty-print a Jess global"
  (bind ?__global (call (engine) findDefglobal ?__global))
  (printout t (call ?__global toString) crlf))

(deffunction ppdeftemplate (?__template)
  "Pretty-print a Jess template"
  (bind ?__template (call (engine) findDeftemplate ?__template))
  (printout t (call ?__template toString) crlf))

(deffunction facts ()
  "List all facts on the fact-list"
  (bind ?__e (call (engine) listFacts))
  (bind ?__fi 0)
  (while (call ?__e hasNext)
    (bind ?__fact (call ?__e next))
    (printout t "f-" (call ?__fact getFactId)
              "   " (call ?__fact toString) crlf)
    (bind ?__fi (+ ?__fi 1)))
  (printout t "For a total of " ?__fi " facts." crlf))

(deffunction rules ()
  "List all rules"
  (bind ?__e (call (engine) listDefrules))
  (bind ?__i 0)
  (while (call ?__e hasNext)
    (bind ?__r (call ?__e next))
    (printout t (call ?__r getName) crlf)
    (bind ?__i (+ ?__i 1)))
  (printout t "For a total of " ?__i " rules." crlf))

(deffunction fact-slot-value (?__fact ?__name)
  "Fetch the value from the named slot of the given fact"
  (return (call ?__fact getSlotValue ?__name)))

(deffunction run-until-halt ()
  "Run until halt is called."
  (call (engine) runUntilHalt))

