
DROP TABLE IF EXISTS contain;
CREATE TABLE contain (
  ID bigint NOT NULL PRIMARY KEY,
  containerId varchar(100) default NULL,
  ppcUrl varchar(255) default NULL,
  ppcType varchar(50) default NULL,
  ppcId varchar(100) default NULL,
  duplicate tinyint default NULL,
  containmentSpecified tinyint default NULL,
  howOldIsAcceptableTime double default NULL,
  howOldIsAcceptableTimeUnit varchar(15) default NULL,
  UNIQUE (containerId,ppcId)
);
DROP TABLE IF EXISTS figlocation;
CREATE TABLE figlocation (
  ID bigint NOT NULL PRIMARY KEY,
  containerFigOwnerId varchar(100) default NULL,
  figOwnerID varchar(100) default NULL,
  toppos smallint default NULL,
  leftpos smallint default NULL,
  UNIQUE (containerFigOwnerId,figOwnerID)
);
DROP TABLE IF EXISTS inferencetoolregistry;
CREATE TABLE inferencetoolregistry (
  ID int NOT NULL PRIMARY KEY,
  order_ int default 0,
  name varchar(255) default NULL,
  className varchar(255) default NULL,
  userFriendlyName varchar(255) default NULL,
  location varchar(255) default NULL,
  supportFileNeeded tinyint default NULL,
  canWorkWithoutSupportFile tinyint default NULL,
  description longvarchar,
  abstractionTool tinyint default NULL,
  actionTool tinyint default NULL,
  editorName varchar(255) default NULL,
  editorClass varchar(255) default NULL,
  toolType varchar(50) default NULL
);
DROP TABLE IF EXISTS lume;
CREATE TABLE lume (
  ID varchar(100) NOT NULL PRIMARY KEY,
  name varchar(100) default NULL,
  description longvarchar,
  state varchar(20) default NULL,
  value varchar(255) default NULL,
  value_list longvarchar,
  value_type varchar(50) default NULL,
  abs_rules_file varchar(255) default NULL,
  absInfToolId int default NULL,
  abs_inftool_class varchar(255) default NULL,
  abs_inftool_type varchar(50) default NULL,
  value_description varchar(255) default NULL,
  default_value varchar(255) default NULL,
  use_default_value_if_null tinyint default NULL,
  asso_info_url varchar(255) default NULL,
  canHaveNullValue tinyint default NULL,
  publish tinyint default NULL,
  publish2 varchar(10) default 'true',
  category varchar(255) default NULL,
  context varchar(255) default NULL,
  owner varchar(255) default NULL,
  ownerEmailAddress varchar(255) default NULL,
  author varchar(255) default NULL,
  authorEmailAddress varchar(255) default NULL,
  lumeType varchar(50) default NULL,
  term varchar(255) default NULL,
  information longvarchar,
  creationDate datetime default NULL,
  modificationDate datetime default NULL,
  UNIQUE (ID)
);
DROP TABLE IF EXISTS lump;
CREATE TABLE lump (
  ID varchar(100) NOT NULL PRIMARY KEY,
  name varchar(100) default NULL,
  description longvarchar,
  value varchar(255) default NULL,
  state varchar(20) default NULL,
  value_list longvarchar,
  value_type varchar(50) default NULL,
  abs_rules_file varchar(255) default NULL,
  absInfToolId int default NULL,
  abs_inftool_class varchar(255) default NULL,
  abs_inftool_type varchar(50) default NULL,
  act_rules_file varchar(255) default NULL,
  actInfToolId int default NULL,
  act_inftool_class varchar(255) default NULL,
  act_inftool_type varchar(50) default NULL,
  sub_act_rules_file varchar(255) default NULL,
  value_description varchar(255) default NULL,
  default_value varchar(255) default NULL,
  use_default_value_if_null tinyint default NULL,
  asso_info_url varchar(255) default NULL,
  canHaveNullValue tinyint default NULL,
  publish tinyint default NULL,
  category varchar(255) default NULL,
  context varchar(255) default NULL,
  owner varchar(255) default NULL,
  ownerEmailAddress varchar(255) default NULL,
  author varchar(255) default NULL,
  authorEmailAddress varchar(255) default NULL,
  term varchar(255) default NULL,
  information longvarchar,
  creationDate datetime default NULL,
  modificationDate datetime default NULL
);
DROP TABLE IF EXISTS pal;
CREATE TABLE pal (
  ID varchar(100) NOT NULL PRIMARY KEY,
  name varchar(100) default NULL,
  description longvarchar,
  state varchar(20) default NULL,
  owner_ID varchar(100) default NULL,
  start varchar(100) default NULL,
  end_ varchar(100) default NULL,
  type varchar(50) default NULL,
  iterations int default NULL,
  delay decimal(20,0) default NULL,
  delayUnit varchar(50) default NULL,
  creationDate date default NULL,
  modificationDate date default NULL
);
DROP TABLE IF EXISTS pide;
CREATE TABLE pide (
  ID varchar(100) NOT NULL PRIMARY KEY,
  name varchar(100) default NULL,
  description longvarchar,
  state varchar(20) default NULL,
  value_type varchar(50) default NULL,
  value_list longvarchar,
  value varchar(255) default NULL,
  value_description varchar(255) default NULL,
  default_value varchar(255) default NULL,
  use_default_value_if_null tinyint default NULL,
  canHaveNullValue tinyint default NULL,
  publish tinyint default NULL,
  category varchar(255) default NULL,
  context varchar(255) default NULL,
  owner varchar(255) default NULL,
  ownerEmailAddress varchar(255) default NULL,
  author varchar(255) default NULL,
  authorEmailAddress varchar(255) default NULL,
  asso_info_url varchar(255) default NULL,
  term varchar(255) default NULL,
  information longvarchar,
  creationDate datetime default NULL,
  modificationDate datetime default NULL
);
DROP TABLE IF EXISTS protocol;
CREATE TABLE protocol (
  ID varchar(100) NOT NULL PRIMARY KEY,
  name varchar(100) default NULL,
  description longvarchar,
  value varchar(250) default NULL,
  state varchar(20) default NULL,
  value_list longvarchar,
  value_type varchar(50) default NULL,
  abs_rules_file varchar(255) default NULL,
  absInfToolId int default NULL,
  abs_inftool_class varchar(255) default NULL,
  abs_inftool_type varchar(50) default NULL,
  act_rules_file varchar(255) default NULL,
  actInfToolId int default NULL,
  act_inftool_class varchar(255) default NULL,
  act_inftool_type varchar(50) default NULL,
  sub_act_rules_file varchar(255) default NULL,
  value_description varchar(255) default NULL,
  default_value varchar(255) default NULL,
  use_default_value_if_null tinyint default NULL,
  canHaveNullValue tinyint default NULL,
  publish tinyint default NULL,
  category varchar(255) default NULL,
  context varchar(255) default NULL,
  owner varchar(255) default NULL,
  ownerEmailAddress varchar(255) default NULL,
  author varchar(255) default NULL,
  authorEmailAddress varchar(255) default NULL,
  asso_info_url varchar(255) default NULL,
  term varchar(255) default NULL,
  disease varchar(255) default NULL,
  information longvarchar,
  creationDate datetime default NULL,
  modificationDate datetime default NULL
);
DROP TABLE IF EXISTS pubmed_filter;
CREATE TABLE pubmed_filter (
  id int NOT NULL PRIMARY KEY,
  name varchar(50) default NULL,
  filter longvarchar
);
DROP TABLE IF EXISTS recent;
CREATE TABLE recent (
  id int NOT NULL PRIMARY KEY,
  typeID int NOT NULL,
  value varchar(255) NOT NULL
);
DROP TABLE IF EXISTS recenttype;
CREATE TABLE recenttype (
  id int NOT NULL PRIMARY KEY,
  type varchar(45) NOT NULL
);
DROP TABLE IF EXISTS setup;
CREATE TABLE setup (
  id int NOT NULL PRIMARY KEY,
  browser varchar(200) default NULL,
  browserPath varchar(200) default NULL,
  editor varchar(200) default NULL,
  editorPath varchar(200) default NULL,
  outputTo varchar(10) default NULL,
  user varchar(20) default NULL,
  defaultAbsInfTool int default NULL,
  defaultActInfTool int default NULL
);
DROP TABLE IF EXISTS value;
CREATE TABLE value (
  id varchar(100) NOT NULL PRIMARY KEY,
  value varchar(255) default NULL,
  random varchar(100) default NULL,
  creationDate date default NULL,
  modificationDate date default NULL
);
DROP TABLE IF EXISTS valuecontain;
CREATE TABLE valuecontain (
  ID bigint NOT NULL PRIMARY KEY,
  containerId varchar(100) default NULL,
  valueId varchar(100) default NULL,
  UNIQUE (containerId,valueId)
);

