DROP TABLE IF EXISTS actionrule;
CREATE TABLE actionrule (
  id varchar(100) NOT NULL PRIMARY KEY,
  name varchar(255) default NULL,
  description longvarchar,
  type tinyint default NULL,
  triggerKcId varchar(100) default NULL,
  text longvarchar,
  order_ smallint default NULL,
  UNIQUE (id),
  UNIQUE (id,order_)
);


DROP TABLE IF EXISTS atom;
CREATE TABLE atom (
  id varchar(100) NOT NULL PRIMARY KEY,
  entityId varchar(100) default NULL,
  ownerPpcId varchar(100) default NULL,
  name varchar(100) default NULL,
  description longvarchar,
  type tinyint default NULL,
  object longvarchar,
  valueDataType varchar(16) default NULL,
  figId varchar(100) NOT NULL
);


DROP TABLE IF EXISTS contain;
CREATE TABLE contain (
  id int NOT NULL PRIMARY KEY,
  containerId varchar(100) NOT NULL,
  containeeId varchar(100) NOT NULL,
  UNIQUE (containerId,containeeId)
);


DROP TABLE IF EXISTS expression;
CREATE TABLE expression (
  id varchar(100) NOT NULL PRIMARY KEY,
  name varchar(50) default NULL,
  description longvarchar,
  type tinyint default NULL,
  operator tinyint default NULL,
  figId varchar(100) default NULL
);


DROP TABLE IF EXISTS fglocation;
CREATE TABLE fglocation (
  id int NOT NULL PRIMARY KEY,
  ownerNodeId varchar(100) default NULL,
  type tinyint default NULL,
  x smallint default NULL,
  y smallint default NULL
);


DROP TABLE IF EXISTS inference;
CREATE TABLE inference (
  id varchar(100) NOT NULL PRIMARY KEY,
  entityId varchar(100) default NULL,
  name varchar(50) default NULL,
  description longvarchar,
  strengthOfRecommendation double default NULL,
  type tinyint default NULL,
  inference longvarchar,
  degreeOfCertainty tinyint default NULL,
  explanation longvarchar,
  externalResource longvarchar,
  calculatedValueType varchar(12) default NULL
);


DROP TABLE IF EXISTS rule;
CREATE TABLE rule (
  id varchar(100) NOT NULL PRIMARY KEY,
  name varchar(255) default NULL,
  description longvarchar,
  type tinyint default NULL,
  text longvarchar,
  order_ smallint default NULL,
  UNIQUE (id)
);


DROP TABLE IF EXISTS syntax;
CREATE TABLE syntax (
  id int NOT NULL PRIMARY KEY,
  syntaxName varchar(50) NOT NULL,
  header longvarchar,
  absRuleInit longvarchar NOT NULL,
  actRuleInit longvarchar NOT NULL,
  ruleBody longvarchar NOT NULL,
  absInference longvarchar NOT NULL,
  actInference longvarchar NOT NULL,
  expression longvarchar NOT NULL,
  atom longvarchar NOT NULL
);


