<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSPY v5 rel. 3 U (http://www.xmlspy.com) by Hemant Shah (City of Hope Medical Center) -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:template match="/">
			/**  Rule
			<xsl:value-of select="rule/@name"/>
		<xsl:choose>
			<xsl:when test="rule/@type = 0"> type: Abstraction</xsl:when>
			<xsl:when test="rule/@type = 1"> type: Action</xsl:when>
		</xsl:choose>
		<br/> * 
		<xsl:apply-templates select="rule/description"> </xsl:apply-templates>
		<br/>*/<br/>
		<br/>
		<br/>
		<!-- initializing-->
		<xsl:choose>
			<xsl:when test="rule/@type = 0">private Inference inf; </xsl:when>
			<xsl:when test="rule/@type = 1">private Vector actions = new Vector();</xsl:when>
		</xsl:choose>
		<br/>
		<br/>
			if <xsl:apply-templates select="rule/expression"> </xsl:apply-templates>
		<br/>
	</xsl:template>
	
	<!-- expression-->
	<xsl:template match="expression">
	
		(<xsl:for-each select=".">
				<xsl:call-template name="operator"><xsl:with-param name="op" select="./@operator"></xsl:with-param></xsl:call-template>
				<xsl:apply-templates/>
		</xsl:for-each>)
	</xsl:template>
	<!-- atom -->
	<xsl:template match="atom">
	atom 
	</xsl:template>
	<!-- inference -->
	<xsl:template match="inference">
	inference 
	</xsl:template>
	<!-- description-->
	<xsl:template match="description">
	<b>description</b>
	</xsl:template>
	<!-- description-->
	<xsl:template name="operator">
	<xsl:param name="op"/>
	<xsl:choose>
		<xsl:when test="$op = 2"> and </xsl:when>
		<xsl:when test="$op = 3"> = </xsl:when>
		<xsl:otherwise> ? </xsl:otherwise>
	</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
